/************************************************************/
/* Copyright (c) Matsushita Electric Industrial Co.,Ltd.    */
/* All rights reserved                                      */
/* Copyright (c) 2008-2009 Panasonic Corporation			*/
/* All Rights Reserved.										*/
/*  ŏIXV	: 2008/9/25									*/
/************************************************************/


/*==========錾==========*/
/* SDO[owb_ */
/* J[lwb_ */
#include <linux/delay.h>
#include "sdapi_define.h"
#include <SddApi.h>
#include "sd_api.h"
#include "sd_ioctl.h"
#include <sdpnp_api.h>
#define GLOBAL_VALUE_DEFINE
#include "sdds_main.h"
#include "sdds_ioctl.h"

/************************************************************/
/* ֐̃vg^Cv錾                                   */
/************************************************************/
static UINT32 PNP_F_event(UINT32 event);	// ݃nh
/*==========錾܂==========*/

/*==========֐==========*/
/************************************************************/
/* ֐: PNP_F_Open                                       */
/* @\  : hCoOpen                                   */
/*   : struct inode *inode ; foCXǗ|C^   */
/*         struct file  *filp  ; t@C\̃|C^     */
/* ߂l: int ; open֐̌                             */
/************************************************************/
static int PNP_F_Open(struct inode *inode, struct file *filp)
{
	if(pnp_dev.open_cnt){		// dopen֎~
		printk("SD_PNP: Multiple open of PNP_F_Open\n");
		return -EALREADY;	// openς
	}else{
		pnp_dev.open_cnt ++;	// openJEg
		filp->private_data = &pnp_dev;
	}
	return 0;
}

/************************************************************/
/* ֐: PNP_F_Close                                      */
/* @\  : hCoClose                                  */
/*   : struct inode *inode; foCXǗ|C^    */
/*         struct file  *filp ; t@C\̃|C^      */
/* ߂l: 0   ; K                                   */
/************************************************************/
static int PNP_F_Close(struct inode *inode, struct file *filp)
{
	struct	SD_PNP_device		*dev = filp->private_data;


	dev->open_cnt --;		// openJEg
	return 0;
}

/****************************************************************/
/* ֐e[u                                                 */
/****************************************************************/
static int (*DS_ioctl_tbl[])(struct SD_PNP_device *dev, unsigned long arg) =
{
	&DS_P_getparam,
	&DS_P_card_init,
	&DS_P_detect,
	&DS_P_insdel
};

/****************************************************************/
/* ֐: PNP_F_Ioctl                                           */
/* @\  : DSioctl                                            */
/*   : struct inode  *inode ;                               */
/*         struct file   *filp  ;                               */
/*         unsigned int  cmd	;                               */
/*         unsigned long arg	;                               */
/* ߂l: int ;                                                */
/****************************************************************/
static int PNP_F_Ioctl(struct inode *inode, struct file *filp,
			unsigned int cmd, unsigned long arg){

	int		err=0;
	int	minor = MINOR(inode->i_rdev) & 0x0f;
	struct	SD_PNP_device		*dev = filp->private_data;


	if(minor != SD_DS_MINOR){	// Device NO Check
		return -ENODEV;
	}

	/* don't even decode wrong cmds: better returning  ENOTTY than EFAULT */
	if (_IOC_TYPE(cmd) != SD_DS_IOC_MAGIC) {
		return -ENOTTY;
	}
	if (_IOC_NR(cmd) > DEF_SD_DS_IOC_MAXNR) {
		return -ENOTTY;
	}

	/*
	 * the type is a bitmask, and VERIFY_WRITE catches R/W
	 * transfers. Note that the type is user-oriented, while
	 * verify_area is kernel-oriented, so the concept of "read" and
	 * "write" is reversed
	 */
	if (_IOC_DIR(cmd) & _IOC_READ)
		err = !access_ok(VERIFY_WRITE, (void *)arg, _IOC_SIZE(cmd));
	else if (_IOC_DIR(cmd) & _IOC_WRITE)
		err =  !access_ok(VERIFY_READ, (void *)arg, _IOC_SIZE(cmd));
	if (err) {
		return -EFAULT;
	}

	// execute Command
	err = DS_ioctl_tbl[_IOC_NR(cmd)-1](dev,arg);
	return err;
}

/************************************************************/
/* ֐: PNP_F_event                                      */
/* @\  : 荞݃nh                                 */
/*   : Cxg                                     */
/* ߂l: 0                                                */
/************************************************************/
static UINT32 PNP_F_event(UINT32 event)
{
	switch(event){
		case EVENT_CARD_INSERTION:	// Card Insert
//@2009.8.26			mdelay(1000);
			pnp_dev.card_event = SD_CARD_INSERT;
			pnp_dev.pending = 1;	// 荞݂tOZbg
			wake_up_interruptible(&pnp_dev.irq_wait);  // Wake UP!
			break;
		case EVENT_CARD_REMOVAL:	// Card Remove
			pnp_dev.card_event = SD_CARD_REMOVE;
			pnp_dev.pending = 1;	// 荞݂tOZbg
			wake_up_interruptible(&pnp_dev.irq_wait);  // Wake UP!
			break;
		default:
			break;
	}

	return 0;
}

/************************************************************/
/* foCXt@C ; file_operations\                 */
/************************************************************/
static struct file_operations sd_ds_fops =
{
	open:		PNP_F_Open,		// Open\bh
	release:	PNP_F_Close,	// Release\bh
	ioctl:		PNP_F_Ioctl,	// Ioctl\bh
};

/************************************************************/
/* ֐: PNP_F_init                                        */
/* @\  : hCȍ                                 */
/*   : Ȃ                                             */
/* ߂l: int ; register_chrdev֐̌                  */
/************************************************************/
static int PNP_F_Init(void){

	static int iRet = SD_SUCCESS;
	static int i;
    SDD_ERROR uw_Result;

	/* eϐ̏ */
	gSDStatus.open_cnt = 0;
	gSDStatus.irq_wait.pending = 0;
	gSDStatus.thread_wait.pending = 0;
	gSDStatus.event = EVENT_NOTHING;
	gSDStatus.fd = 0;
	gSDStatus.insert = 0;	// J[hE(CardManagerΉ͕sv)
	for( i = 0 ; i < SD_CS_CLIENT_MAX ; i++ ){
		gSDStatus.event_handler[i] = NULL;
	}

	/*--- Z}tH̏ ---*/
	sema_init(&gSDStatus.client_sem, 1);


    /* SDD  */
    SDD_Init();

    /* SDD Attach */
    uw_Result = SDD_Attach();
	if(uw_Result != SDD_SUCCESS){
		iRet = -1;
		return iRet;
	}

	/**************************************************/
	/* o[WA[LeN`̕\GA */
	/**************************************************/
	/*---o[W---*/
//	printk("SD Card Core Driver : Ver.%02x\n", VERSION_INFO);

	/*---A[LeN`---*/
#ifdef _SDD_MARVIE_AV_ 
    printk("AVR4M System(SoC-SD)\n");
#endif 

#ifdef _SDD_PEAKS_AVC_
    printk("PH1 System(Soc-SD Ver0.3)\n");
#endif  

	/* o[W\ */
	printk( "SD-CS Driver Service : Ver.%02x\n", VERSION_INFO );

	/* eϐ̏ */
	pnp_dev.pending = 0;		// 荞ݔtO
	pnp_dev.open_cnt = 0;		// I[vJEg
	pnp_dev.fd = 0;			// CSfd
	pnp_dev.card_event = EVENT_NOTHING;	// Interrupt event

	/* L[̏ */
	init_waitqueue_head(&pnp_dev.irq_wait);

	/* Set up owner pointers.*/
#ifdef SET_MODULE_OWNER
	SET_MODULE_OWNER(&sd_ds_fops);
#endif

	iRet = register_chrdev(SD_DS_MAJOR, "SD_CS_ds", &sd_ds_fops);	// 241
	if (iRet < 0) {
		printk("### SD_DS: register_chrdev failure ###\n");
		return iRet;
	}

	/* CS_open/Irq_Request/Card_Init */
	if((( pnp_dev.fd = SD_F_Open() ) < 0 ) 	// CS open
	|| ( SD_F_Ioctl(pnp_dev.fd, SD_IOC_REQUEST_IRQ, (ULONG)&PNP_F_event) < 0 )){	// 荞݃nho^
		printk("### SD_DS: SD_F_Open and REQUEST_IRQ failure ###\n");
		goto fin_init;
	}

	/* SDJ[h̏iNbNݒEJ[hʂ̔ʁj */
//@2009.8.27	DS_P_card_init(&pnp_dev, 0);


	return 0;

fin_init:
	unregister_chrdev(SD_DS_MAJOR, "SD_CS_ds");
	pnp_dev.fd = 0;
	return -EIO;

}

/************************************************************/
/* ֐: PNP_F_cleanup                                     */
/* @\  : hCȍI                               */
/*   : Ȃ                                             */
/* ߂l: Ȃ                                             */
/************************************************************/
static void PNP_F_Cleanup(void)
{
	SD_F_Ioctl(pnp_dev.fd, SD_IOC_FREE_IRQ, 0);	// 荞݃nh폜
	SD_F_Close(pnp_dev.fd);				// CS close
	unregister_chrdev(SD_DS_MAJOR, "SD_CS_ds");

    /* SDD Detach */
    SDD_Detach();
}
/*==========֐܂==========*/

/************************************************************/
/* module̓o^                                       */
/************************************************************/
module_init(PNP_F_Init);
module_exit(PNP_F_Cleanup);
MODULE_LICENSE("Proprietary");
